import java.util.*;

/** Program for Lab: Timing execution */
public class TestArrays extends JLiveWindow {
   public TestArrays(int i, int d, int s)
      {super(i, d, s);}
      
   public static void main(String pars[]) {
      // Create and store in d a new GUI, which has 7 int and String fields.
         TestArrays d= new TestArrays(7,0,7;
         d.showWindow();
   }
   
   public Object buttonPressed() {
      Date timeStart= new Date();
      Date timeEnd= new Date();
      
      System.out.println(timeStart);
      System.out.println("Time timeStart, in milliseconds: " + timeStart.getTime());
      System.out.println();
      System.out.println(timeEnd);
      System.out.println("Time timeStart, in milliseconds: " + timeEnd.getTime());
   
      return null;
   }
   
   /** Read a number m from int field 0 and execute selection sort and
       selection sort m times on an array of 5000 elements. Print results in
       the GUI. */
   public void testSorts() {
      int i; // loop counter
      
      Date timeStart;
      Date timeEnd;      
      
      int m= getIntField(0);  // number of times to execute algorithm
      int[] b= new int[5000]; // array to sort
      
      
      // Run selection sort m times and print the results
         setIntField(1,0);
         setStringField(1, "Running selection sort");
         setStringField(2," ");

         timeStart= new Date();
         for (i= 0; i < m; i++) {
            fillbneg(b);
            Sorting.selectionSort(b);
         }
         timeEnd= new Date();
      
         setStringField(0, "Number of iterations");
         setIntField(1, (int)(timeEnd.getTime()-timeStart.getTime()));
         setStringField(1, "time for selectionSort");
         
       // Run insertion sort m times and print the results
          setIntField(2,0);
          setStringField(2, "Running insertion sort");
          timeStart= new Date();
            
          for (i= 0; i < m; i++) {
             fillbneg(b);
             Sorting.insertionSort(b,0,b.length-1);
          }     
          timeEnd= new Date();
       
          setStringField(0, "Number of iterations");
          setIntField(2, (int)(timeEnd.getTime()-timeStart.getTime()));
          setStringField(2, "time for insertionSort");
   }
   
      
   // Fill array b: in b[i] goes -i
   public void fillbneg(int[] b) {
      for (int i= 0; i != b.length; i++)
          b[i]= -i;
   }
   
     // Fill array b: in b[i] goes i
   public void fillbpos(int[] b) {
      for (int i= 0; i != b.length; i++)
          b[i]= i;
   }
   
   // Read a number m from int field 0 and execute linear search and
   // binary search m times on an array of 100000 elements. Print results in
   // the GUI
   public void testSearches() {
      int i; // loop counter
      
      Date timeStart;
      Date timeEnd;
      
      int m= getIntField(0);  // number of times to execute algorithm
      int[] b= new int[100000]; // array to sort
      
      
      // Run linear search m times and print the results
         setIntField(1,0);
         setStringField(1, "Running linear search sort");
         setStringField(2," ");

         fillbpos(b);
         timeStart= new Date();
         for (i= 0; i < m; i++) {
            int anser= Sorting.linearSearch(b,b.length);
         }
         timeEnd= new Date();
      
         setStringField(0, "Number of iterations");
         setIntField(1, (int)(timeEnd.getTime()-timeStart.getTime()));
         setStringField(1, "time for Linear search");
         
       // Run binary search m times and print the results
          setIntField(2,0);
          setStringField(2, "Running binary search");
          fillbpos(b);
          timeStart= new Date();
            
          for (i= 0; i < m; i++) {
             int bs= Sorting.binarySearch(b,b.length);
          }     
          timeEnd= new Date();
       
          setStringField(0, "Number of iterations");
          setIntField(2, (int)(timeEnd.getTime()-timeStart.getTime()));
          setStringField(2, "time for binary search");

   }
}
